@extends('adminlte::page')

@section('title', 'Daftar Visitor')

@section('content_header')
    <h1>Daftar Visitor</h1>
@stop

@section('content')
@if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
@endif

<div class="d-flex justify-content-between align-items-center mb-3">
    <a href="{{ route('visitor.create') }}" class="btn btn-success btn-sm">
        <i class="fas fa-plus"></i> Tambah Visitor
    </a>
    <form method="GET" action="{{ route('visitor.index') }}" class="d-flex" style="max-width:190px;">
        <div class="input-group input-group-sm">
            <input type="text" name="q" value="{{ request('q') }}" class="form-control" placeholder="Cari nama/kontak/alamat...">
            <button class="btn btn-primary btn-sm" type="submit">
                <i class="fas fa-search"></i>
            </button>
        </div>
    </form>
</div>
<table class="table table-bordered table-hover">
    <thead>
        <tr>
            <th>Nama</th>
            <th>Kontak</th>
            <th>Alamat</th>
            <th>Kunjungan Hari Ini</th>
            <th style="width:280px;">Aksi</th>
            <!--<th>Hapus</th>-->
        </tr>
    </thead>
    <tbody>
        @forelse($visitors as $visitor)
        <tr>
            <td>{{ $visitor->nama }}</td>
            <td>{{ $visitor->kontak }}</td>
            <td>{{ $visitor->alamat }}</td>
            <td>
                {{ $visitor->attendances()->where('tanggal', date('Y-m-d'))->count() }} x
            </td>
            <td>
                <button class="btn btn-xs btn-info open-visit-modal"
                        data-toggle="modal"
                        data-target="#visitModal"
                        data-visitor-id="{{ $visitor->id }}"
                        data-visitor-nama="{{ $visitor->nama }}"
                        data-visit-only-price="{{ $visit_only_price ?? '' }}">
                    <i class="fas fa-calendar-check"></i> + Kunjungan
                </button>
                <a href="{{ route('visitor.to-member', $visitor->id) }}" class="btn btn-success btn-xs"><i class="fas fa-plus"></i> Member</a>
                <a href="{{ route('visitor.edit', $visitor->id) }}" class="btn btn-warning btn-xs">Edit</a>
            </td>
            <!--<td> @if(auth()->user()->role == 'admin')
                <form action="{{ route('visitor.destroy', $visitor->id) }}" method="POST" style="display:inline;">
                    @csrf @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-xs"
                        onclick="return confirm('Yakin hapus?')">Hapus</button>
                </form>
                @endif
            </td>-->
        </tr>
        @empty
        <tr>
            <td colspan="6" class="text-center">Belum ada visitor.</td>
        </tr>
        @endforelse
    </tbody>
</table>

<div>
    {{ $visitors->links() }}
</div>

<!-- Modal statis -->
<div class="modal fade" id="visitModal" tabindex="-1" role="dialog" aria-labelledby="visitModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="visitModalLabel">Tambah Kunjungan: <span id="visitorName"></span></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                {{-- Hidden input to store current visitor ID --}}
                <input type="hidden" id="currentVisitorId" value="">

                <div class="form-group">
                    <label>Pilih Tipe Kunjungan</label>
                    <select class="form-control tipe-kunjungan" id="tipe-kunjungan" onchange="showVisitFormDynamic()">
                        <option value="">-- Pilih --</option>
                        <option value="mandiri">Latihan Mandiri</option>
                        <option value="pt">Personal Trainer</option>
                    </select>
                </div>

                {{-- FORM LATIHAN MANDIRI --}}
                <form id="form-mandiri" method="POST" style="display:none;">
                    @csrf
                    <input type="hidden" name="visit_type" value="mandiri">
                    <input type="hidden" name="harga" id="harga-visit-mandiri-hidden">
                    <div class="form-group">
                        <label>Harga Visit</label>
                        <input type="text" class="form-control" name="harga_display" id="harga-visit-mandiri" readonly>
                    </div>
                    <div class="form-group">
                        <label>Pembayaran</label>
                        <input type="number" class="form-control bayar-input" name="bayar" id="bayar-mandiri" placeholder="Nominal bayar" required>
                    </div>
                    <div class="form-group">
                        <label>Kembalian</label>
                        <input type="text" class="form-control" id="kembalian-mandiri" readonly>
                        <input type="hidden" name="kembalian" id="kembalian-mandiri-hidden">
                    </div>
                    <div class="form-group">
                        <label>Metode Pembayaran</label>
                        <select class="form-control" name="payment_method" required>
                            <option value="cash">Cash</option>
                            <option value="debit">QRIS</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-success btn-block">Simpan & Cetak Nota</button>
                </form>

                {{-- FORM PERSONAL TRAINER --}}
                <form id="form-pt" method="POST" style="display:none;">
                    @csrf
                    <input type="hidden" name="visit_type" value="pt">
                    <input type="hidden" name="buyer_type" value="visitor">
                    <input type="hidden" name="buyer_id" id="buyer-id-pt">
                    <input type="hidden" name="tanggal" id="tanggal-pt" value="{{ date('Y-m-d') }}">
                    <div class="form-group">
                        <label>Pilih Produk PT</label>
                        <select class="form-control produk-pt" name="produk_id" id="produk-pt" required>
                            @foreach($pt_products as $product)
                                <option value="{{ $product->id }}" data-harga="{{ $product->harga }}">{{ $product->nama }} - Rp {{ number_format($product->harga,0,',','.') }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Pilih Instruktur</label>
                        <select class="form-control" name="instruktur_id" required>
                            @foreach($instructors as $ins)
                                <option value="{{ $ins->id }}">{{ $ins->nama }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="form-group">
                        <label>Harga</label>
                        <input type="text" class="form-control" id="harga-pt" readonly>
                        <input type="hidden" name="harga" id="harga-pt-hidden">
                    </div>
                    <div class="form-group">
                        <label>Biaya Masuk</label>
                        <input type="text" class="form-control" id="harga-visit-only-pt" value="Rp {{ number_format($visit_only_price,0,',','.') }}" readonly>
                    </div>
                    <div class="form-group">
                            <label><b>Total Harga (PT + Biaya Masuk)</b></label>                 
                            <input type="text" class="form-control" id="harga-pt-total" readonly>
                    </div>
                    <!-- <input type="hidden" name="harga" id="harga-pt-total-angka"> Untuk submit -->
                    <!--<div class="form-group">
                        <b>Biaya Masuk :</b> 
                        <span id="biaya_masuk">Rp {{ number_format($visit_only_price, 0, ',', '.') }}</span>
                    </div>-->
                    <div class="form-group">
                        <label>Pembayaran</label>
                        <input type="number" class="form-control bayar-input" name="bayar" id="bayar-pt" placeholder="Nominal bayar" required>
                    </div>
                    <div class="form-group">
                        <label>Kembalian</label>
                        <input type="text" class="form-control" id="kembalian-pt" readonly>
                        <input type="hidden" name="kembalian" id="kembalian-pt-hidden">
                    </div>
                    <div class="form-group">
                        <label>Metode Pembayaran</label>
                        <select class="form-control" name="payment_method" required>
                            <option value="cash">Cash</option>
                            <option value="transfer">Transfer</option>
                        </select>
                    </div>
                    <button type="submit" class="btn btn-success btn-block">Simpan & Cetak Nota</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('js')
<script>
// =========================================================================
// UTILITY FUNCTIONS
// =========================================================================

/**
 * Memformat angka menjadi format Rupiah (Rp X.XXX.XXX)
 * @param {number} angka - Angka yang akan diformat.
 * @returns {string} - String angka dalam format Rupiah.
 */
function formatRupiah(angka) {
    angka = angka || 0; // Pastikan angka tidak null atau undefined
    return "Rp " + angka.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ".");
}

/**
 * Mengurai string format Rupiah atau string angka menjadi integer.
 * Fungsi ini lebih cerdas dalam menangani berbagai format input.
 * @param {string|number} str - String atau angka yang akan diurai.
 * @returns {number} - Angka integer hasil penguraian.
 */
function parseAngka(str) {
    if (typeof str === 'number') {
        return str; // Jika sudah angka, langsung kembalikan
    }
    if (typeof str !== 'string') {
        return 0; // Jika bukan string atau angka, kembalikan 0
    }

    // Jika string dimulai dengan "Rp", hapus "Rp " dan titik pemisah ribuan
    if (str.startsWith('Rp')) {
        return parseInt(str.replace(/Rp\s?|\./g, '')) || 0;
    }
    // Jika string adalah angka biasa (misal "30000.00" atau "50000")
    // parseInt akan mengabaikan bagian desimal setelah titik pertama
    return parseInt(str) || 0;
}

// =========================================================================
// GLOBAL CONSTANTS
// =========================================================================

// Harga kunjungan mandiri, diambil dari variabel PHP
const VISIT_ONLY_PRICE = {{ $visit_only_price ?? 0 }};

// =========================================================================
// FORM DISPLAY LOGIC
// =========================================================================

/**
 * Menampilkan atau menyembunyikan form kunjungan berdasarkan tipe yang dipilih.
 * Mengatur nilai awal dan action URL form.
 */
function showVisitFormDynamic() {
    const tipe = $('#tipe-kunjungan').val();
    const visitorId = $('#currentVisitorId').val();

    // Sembunyikan semua form terlebih dahulu
    $('#form-mandiri').hide();
    $('#form-pt').hide();

    if (tipe === 'mandiri') {
        $('#form-mandiri').show();
        // Set harga mandiri dan reset input pembayaran/kembalian
        $('#harga-visit-mandiri-hidden').val(VISIT_ONLY_PRICE);
        $('#harga-visit-mandiri').val(formatRupiah(VISIT_ONLY_PRICE));
        $('#bayar-mandiri').val('');
        $('#kembalian-mandiri').val(formatRupiah(0));
        $('#kembalian-mandiri-hidden').val(0);
        $('#form-mandiri').attr('action', `/visitor_attendance/visit_mandiri/${visitorId}`);
    } else if (tipe === 'pt') {
        $('#form-pt').show();
        // Set buyer ID dan tanggal untuk form PT
        $('#buyer-id-pt').val(visitorId);
        $('#tanggal-pt').val(new Date().toISOString().slice(0,10));
        // Reset input pembayaran/kembalian
        $('#bayar-pt').val('');
        $('#kembalian-pt').val(formatRupiah(0));
        $('#kembalian-pt-hidden').val(0);
        $('#form-pt').attr('action', `/visitor_attendance/visit_pt/${visitorId}`);
        // Trigger event 'change' pada dropdown produk PT untuk mengisi harga awal
        $('#produk-pt').trigger('change');
    }
}

// =========================================================================
// EVENT LISTENERS
// =========================================================================

$(document).ready(function() {
    // Sembunyikan form saat dokumen pertama kali dimuat
    $('#form-mandiri').hide();
    $('#form-pt').hide();
    $('#tipe-kunjungan').val(''); // Pastikan dropdown tipe kunjungan direset
});

// Event listener saat tombol "+ Kunjungan" diklik untuk membuka modal
$(document).on('click', '.open-visit-modal', function () {
    const visitorId = $(this).data('visitor-id');
    const visitorNama = $(this).data('visitor-nama');

    // Set ID visitor dan nama di modal
    $('#currentVisitorId').val(visitorId);
    $('#buyer-id-pt').val(visitorId); // Juga set buyer_id untuk form PT
    $('#visitorName').text(visitorNama);

    // Reset state modal
    $('#tipe-kunjungan').val(''); // Reset pilihan tipe kunjungan
    $('#form-mandiri').hide(); // Sembunyikan kedua form
    $('#form-pt').hide();

    // Reset semua input harga dan kembalian di kedua form saat modal dibuka
    // Ini penting untuk memastikan state bersih setiap kali modal dibuka
    $('#harga-visit-mandiri-hidden').val(0);
    $('#harga-visit-mandiri').val(formatRupiah(0));
    $('#bayar-mandiri').val('');
    $('#kembalian-mandiri').val(formatRupiah(0));
    $('#kembalian-mandiri-hidden').val(0);

    $('#harga-pt-hidden').val(0);
    $('#harga-pt').val(formatRupiah(0));
    $('#bayar-pt').val('');
    $('#kembalian-pt').val(formatRupiah(0));
    $('#kembalian-pt-hidden').val(0);
});

/* Event listener saat pilihan produk PT berubah
$(document).on('change', '#produk-pt', function(){
    // Mengambil harga asli (integer) dari atribut data-harga pada opsi yang dipilih
    const hargaAsli = $(this).find(':selected').data('harga') || 0;

    // Tampilkan harga dalam format Rupiah dan simpan nilai asli di hidden input
    $('#harga-pt').val(formatRupiah(hargaAsli));
    $('#harga-pt-hidden').val(hargaAsli);

    // Reset input pembayaran dan kembalian
    $('#bayar-pt').val('');
    $('#kembalian-pt').val(formatRupiah(0));
    $('#kembalian-pt-hidden').val(0);
});*/
$(document).on('change', '#produk-pt', function(){
    const hargaPT = parseInt($(this).find(':selected').data('harga')) || 0;
    const total = hargaPT + VISIT_ONLY_PRICE;
    $('#harga-pt-hidden').val(hargaPT); // <-- untuk database
    $('#harga-pt-total').val(formatRupiah(total)); // <-- hanya tampilan
});

// Event listener saat input pembayaran (bayar-pt) berubah untuk Personal Trainer
$(document).on('input', '#bayar-pt', function(){
    const bayar = parseAngka($(this).val());
    // Ambil harga dari hidden input yang berisi angka mentah
    //const harga = parseAngka($('#harga-pt-hidden').val());
    const harga = parseAngka($('#harga-pt-total').val());   
    let kembalian = bayar - harga;
    const kembalianFinal = kembalian > 0 ? kembalian : 0; // Pastikan kembalian tidak negatif

    // Tampilkan kembalian dalam format Rupiah dan simpan nilai asli di hidden input
    $('#kembalian-pt').val(formatRupiah(kembalianFinal));
    $('#kembalian-pt-hidden').val(kembalianFinal);
});

// Event listener saat input pembayaran (bayar-mandiri) berubah untuk Latihan Mandiri
$(document).on('input', '#bayar-mandiri', function(){
    const bayar = parseAngka($(this).val());
    // Ambil harga dari hidden input yang berisi angka mentah
    const harga = parseAngka($('#harga-visit-mandiri-hidden').val());

    let kembalian = bayar - harga;
    const kembalianFinal = kembalian > 0 ? kembalian : 0; // Pastikan kembalian tidak negatif

    // Tampilkan kembalian dalam format Rupiah dan simpan nilai asli di hidden input
    $('#kembalian-mandiri').val(formatRupiah(kembalianFinal));
    $('#kembalian-mandiri-hidden').val(kembalianFinal);
});

$(document).on('change', '#produk-pt', function(){
    // Ambil harga PT dari data-harga, PASTIKAN integer
    const hargaPT = parseInt($(this).find(':selected').data('harga')) || 0;
    // VISIT_ONLY_PRICE sudah integer

    // Jumlahkan sebagai angka, lalu format
    const total = hargaPT + VISIT_ONLY_PRICE;

    // Set masing-masing field
    $('#harga-pt').val(formatRupiah(hargaPT));                    // Harga PT saja
    $('#harga-visit-only-pt').val(formatRupiah(VISIT_ONLY_PRICE));// Biaya masuk
    $('#harga-pt-total').val(formatRupiah(total));                // Total harga

    // Hidden value untuk backend
    $('#harga-pt-total').attr('name', 'harga');
});

</script>
@endsection
